

import java.awt.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

public class DrawMain {

    public static void main(String[] args) {
        JFrame frame = new JFrame("Draw Panel");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        Container contentPane = frame.getContentPane();
        DrawPanel panel = new DrawPanel();
        contentPane.add(panel);
        frame.pack();
        frame.setVisible(true);

        ComponentLibDialog dialog = new ComponentLibDialog(frame);
        dialog.getComponentManager();
        ContainerManager manager=dialog.getContainerManager();
        ComponentLibPanel componentLibPanel=dialog.getComponentLibPanel();
        ObjectTable.componentLibDialog=dialog;
        ObjectTable.drawPanel=panel;

        createComponents(dialog);

        dialog.showDialog();
    }

    public static void createComponents(ComponentLibDialog dialog) {
        Dimension dim = dialog.getComponentLibPanel().getSizeOfComponent();
        ContainerManager manager=dialog.getContainerManager();
        Shape shape;
        double delta0 = 7;
        int index = 0;
        ShapeContainer container;
        //ContainerManager manager = ObjectTable.getContainerManager();
        for (int i = 0; i < 3; i++) {
            double delta=delta0*i;
            shape = new Rectangle2D.Double(0, 0, dim.width, dim.height - delta);
            //shape = new Rectangle2D.Double(x, y, dim.width - 2 * x, dim.height - 2*y);
            container = new ShapeContainer("rect-" + index, shape);
            manager.addContainer(container);
            index++;
        }
        for (int i = 0; i < 3; i++) {
            double delta=delta0*i;
            shape = new Rectangle2D.Double(0, 0, dim.width - delta, dim.height);
            //shape = new Rectangle2D.Double(x, y, dim.width - 2 * x, dim.height - 2*y);
            container = new ShapeContainer("rect-" + index, shape);
            manager.addContainer(container);
            index++;
        }

        for (int i = 0; i < 3; i++) {
            double delta=delta0*i;
            shape = new Ellipse2D.Double(0, 0, dim.width, dim.height - delta);
            //shape = new Ellipse2D.Double(x, y, dim.width - 2 * x, dim.height - 2*y);
            container = new ShapeContainer("ellipse-" + index, shape);
            manager.addContainer(container);
            index++;
        }
        for (int i = 0; i < 3; i++) {
            double delta=delta0*i;
            shape = new Ellipse2D.Double(0, 0, dim.width - delta, dim.height);
            //shape = new Ellipse2D.Double(x, y, dim.width - 2 * x, dim.height - 2*y);
            container = new ShapeContainer("ellipse-" + index, shape);
            manager.addContainer(container);
            index++;
        }
    }

    public static void createDrawShapes(DrawPanel panel) {
        ContainerManager manager=panel.getContainerManager();
        Shape shape;
        int index = 0;
        ShapeContainer container;
        Dimension drawFrame=new Dimension(50, 50);
        Dimension drawSize=new Dimension(40, 40);
        double x=0, y=0;
        for (int i = 0; i < 3; i++) {
            x=index*drawFrame.width;
            y=50;
            double delta=i*(drawSize.height/5);
            shape = new Ellipse2D.Double(x, y, drawSize.width, drawSize.height - delta);
            //shape = new Ellipse2D.Double(x, y, dim.width - 2 * x, dim.height - 2*y);
            container = new ShapeContainer("ellipse-" + index, shape);
            manager.addContainer(container);
            index++;
        }
        for (int i = 0; i < 3; i++) {
            x=index*drawFrame.width;
            y=50;
            double delta=i*(drawSize.height/5);
            shape = new Ellipse2D.Double(x, y, drawSize.width - delta, drawSize.height);
            //shape = new Ellipse2D.Double(x, y, dim.width - 2 * x, dim.height - 2*y);
            container = new ShapeContainer("ellipse-" + index, shape);
            manager.addContainer(container);
            index++;
        }
    }
}
