

import java.awt.*;
import java.awt.geom.*;

public class ShapeContainer {

    private String shapeId = "";
    private Shape shape = null;
    int debug=0;

    public ShapeContainer(String shapeId, Shape shape) {
        this.shapeId=shapeId;
        this.shape=shape;
    }

    public String getShapeId() {
        return this.shapeId;
    }
    
    public void setShapeId(String shapeId) {
        this.shapeId=shapeId;
    }
    
    public Shape getShape() {
        return this.shape;
    }
    
    public Rectangle2D getBoundingBox() {
        return this.shape.getBounds2D();
    }


    public void drawShape(Graphics g) {
        if (debug >0) System.out.println(" - drawShape start "+ this.getShapeId());
        Graphics2D g2 = (Graphics2D) g;
        Shape shape=this.getShape();
        Rectangle currentClip=g2.getClipBounds();
        Color currentColor=g2.getColor();
        Stroke currentStroke=g2.getStroke();
        double lineWidth=0.5;
        double enLarge=0.5d*lineWidth+10d;
        Rectangle2D enlargedBoundingBox
                =this.getEnlargedRectangle(this.getBoundingBox(), enLarge, enLarge);
        if(enlargedBoundingBox!=null) g2.setClip(enlargedBoundingBox);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, 
                RenderingHints.VALUE_ANTIALIAS_ON);
        Color fillColor=Color.YELLOW;
        g2.setColor(fillColor);
        boolean closed=true;
      //-----------------------------------------------------------//  
        if(closed&&fillColor!=null) g2.fill(shape);
      //-----------------------------------------------------------//  
        Color lineColor=Color.BLACK;
        g2.setColor(lineColor);
      //---------------------------------------------------------------------------//
        g2.draw(shape);
      //---------------------------------------------------------------------------//
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setClip(currentClip); 

        if(debug>0) System.out.println(" - drawShape end");
    }
    
    public Rectangle2D getEnlargedRectangle(Rectangle2D box, double wEx, double hEx) {
        if (box == null) {
            return null;
        }
        double X = box.getX();
        double Y = box.getY();
        double Width = box.getWidth();
        double Height = box.getHeight();
        return new Rectangle2D.Double(X - wEx, Y - hEx, Width + 2.5d * wEx,
                Height + 2.5d * hEx);
    }
    
    public void translate(double x, double y){
        RectangularShape rect=(RectangularShape)this.shape;
        rect.setFrame(x+rect.getX(), y+rect.getY(), rect.getWidth(),rect.getHeight());
    }
    
    public Object clone() {
        Shape shape=this.getShape();
        System.out.println("ShapeContainer clone simple name="+shape.getClass().getSimpleName()+
                ", name="+shape.getClass().getName());
        String name=shape.getClass().getName();
        Shape newShape=null;
        if(name.indexOf("Rectangle2D")>=0){
            Rectangle2D rect=(Rectangle2D)shape;
            newShape=new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        if(name.indexOf("Ellipse2D")>=0){
            Ellipse2D rect=(Ellipse2D)shape;
            newShape=new Ellipse2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        ShapeContainer newContainer=new ShapeContainer("clone", newShape);
        return newContainer;
    }

    public String toString() {
        String str = "";

        return str;
    }

} 
