

import java.awt.*;
import java.awt.datatransfer.*;

public class TransferableComponent implements Transferable {
    public static DataFlavor componentFlavor 
            = new DataFlavor(ShapeContainer.class, "ShapeContainer");
    public static DataFlavor[] supportedFlavors = {componentFlavor};
    ShapeContainer container;

    public TransferableComponent(ShapeContainer container) {
        this.container = container;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return supportedFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(componentFlavor)) {
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(componentFlavor)) {
            return container;
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
    }
}